;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; V_FONTS.LSP                                             ;
;; List of font names for styles named in v_setvar.lsp     ; 
;; Also should include all possible styles if the          ;
;; font-mapping (Style-Set) command is used                ; 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun v_fonts ()             ;; no edit                   ;
(setq stlist (list                                         ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; TEXT STYLE FONTS LIST begins below                      ;
;; Each active line defines the font to use for a style.   ;
;; Two different fonts are possible for each style, for    ;
;; use with Style-set command.                             ;
;;                                                         ;
;; Start line with:  '(                                    ;
;; 1st element:  Style name in quotes                      ;
;; 2nd element:  Fast font name in quotes                  ;
;; 3th element:  Prsentation font name in quotes           ;
;; End line with: )                                        ;
;;                                                         ;
;; Must use minimum 1-space between 1,2, and 3             ;
;; All style names specified in v_setvar.lsp must be       ;
;; listed here.  Additional names are for use with         ;
;; the Style=Set command, and are optional.  Examples      ;
;; below may be deleted if not used.                       ;
;; A semicolon at beginning of line disables the line      ;
;;                                                         ;
;; Note: For Autocad (or any) font files that are located  ;
;; in directories that are listed in the Acad "Support     ;
;; path", it is not recommended that the full path font    ;
;; file name be used--the path becomes "hardcoded' with    ;
;; the style, and if later moved to a different directory, ;
;; will not be found.  ".SHX" extensions may be omitted.   ;
;;                                                         ;
;; For font files not in the "path", the full path         ;
;; font file name must be used.                            ;
;; IMPORTANT: directory paths must use a double backslash  ;
;;      e.g.  c:\\windows\\system\\fontfile.ttf            ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
'("standard"      "TXT"   "ROMANS"   )
'("annsxtext"     "TXT"   "TXT"      )
'("annsymtext"    "TXT"   "TXT"      )
'("anntable"      "TXT"   "TXT"      )
'("anntext"       "TXT"   "ROMANS"   )
'("atttext"       "TXT"   "TXT"      )
'("anndttext"     "TXT"   "TXT"      )

'("bordertextl"   "TXT"   "TXT"      )
'("bordertextm"   "TXT"   "TXT"      )
'("bordertexts"   "TXT"   "TXT"      )

'("dimtext"       "TXT"   "TXT"      ) 
'("gridtext"      "TXT"   "TXT"      )

'("lgdtextl"      "TXT"   "TXT"      )
'("lgdtextm"      "TXT"   "TXT"      )
'("lgdtexts"      "TXT"   "TXT"      )

'("matchtext"     "TXT"   "TXT"      )
'("objtext"       "TXT"   "TXT"      )

'("schtextl"      "TXT"   "TXT"      )
'("schtextm"      "TXT"   "TXT"      )
'("schtexts"      "TXT"   "TXT"      )

'("xfine"         "TXT"   "TXT"      )
'("textl"         "TXT"   "TXT"      )
'("textm"         "TXT"   "TXT"      )
'("texts"         "TXT"   "TXT"      )

'("titleblkl"     "TXT"   "TXT"      )
'("titleblkm"     "TXT"   "TXT"      )
'("titleblks"     "TXT"   "TXT"      )

'("tittextl"      "TXT"   "TXT"      )
'("tittextm"      "TXT"   "TXT"      )
'("tittexts"      "TXT"   "TXT"      )

'("titx1"         "TXT"   "TXT"      )
'("titx2"         "TXT"   "TXT"      )
'("titx3"         "TXT"   "TXT"      )

;;;;;;;;; GEN TEXT COMMANDS ;;;;;;;;;;;;;;;;;;;;;;;;;;;;
'("txg1"          "TXT"   "TXT"      )
'("txg2"          "TXT"   "TXT"      )
'("txg3"          "TXT"   "TXT"      )
'("txg4"          "TXT"   "TXT"      )

;;;;;;;;; TITLE TEXT COMMANDS ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; IF USING FONT FAMILIES with the command                 ;
;;   The style names must be as listed below (the font     ;
;;   names will probably need to be edited--those provided ;
;;   correspond to "X-Font" product).                      ;
;;   Remove any leading semi-colons at each line to        ;
;;   activate, and comment out (w/ semicolons) the         ;
;;   Non-familiy list                                      ;
;; IF NOT USING FONT FAMILIES                              ;
;;   Comment out each line of the Family list. Activate    ;
;;   the Non-family list by removing any leading semi-     ;
;;   colons.  Text style names can be arbitrary (but must  ;
;;   match those in v_setvar.lsp).  Only 4 styles may be   ; 
;;   defined.                                              ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;;;;;;;;; Begin Title-Text for FONT FAMILIES 
; '("H-L1-F"        "X-HLVL1F"   "X-HLVL1D"      )  ;; D=dbl filled
; '("H-L2-F"        "X-HLVL2F"   "X-HLVL2D"      )
; '("H-L3-F"        "X-HLVL3F"   "X-HLVL3D"      )
; '("H-M1-F"        "X-HLVM1F"   "X-HLVM1D"      )
; '("H-M2-F"        "X-HLVM2F"   "X-HLVM2D"      )
; '("H-M3-F"        "X-HLVM3F"   "X-HLVM3S"      )  ;; (Used S, bad D file)
; '("H-B1-F"        "X-HLVB1F"   "X-HLVB1D"      )
; '("H-B2-F"        "X-HLVB2F"   "X-HLVB2D"      )
; '("H-B3-F"        "X-HLVB3F"   "X-HLVB3D"      )

; '("H-L1-O"        "X-HLVL1F"   "X-HLVL1O"      )  ;; O=outline
; '("H-L2-O"        "X-HLVL2F"   "X-HLVL2O"      )
; '("H-L3-O"        "X-HLVL3F"   "X-HLVL3O"      )
; '("H-M1-O"        "X-HLVM1F"   "X-HLVM1O"      )
; '("H-M2-O"        "X-HLVM2F"   "X-HLVM2O"      )
; '("H-M3-O"        "X-HLVM3F"   "X-HLVM3O"      )
; '("H-B1-O"        "X-HLVB1F"   "X-HLVB1O"      )
; '("H-B2-O"        "X-HLVB2F"   "X-HLVB2O"      )
; '("H-B3-O"        "X-HLVB3F"   "X-HLVB3O"      )

; '("H-M1-S"        "S-HLVM1F"   "S-HLVM1S"      )  ;; S=shadow
; '("H-M2-S"        "S-HLVM2F"   "S-HLVM2S"      )
; '("H-M3-S"        "S-HLVM3F"   "S-HLVM3S"      )
;; End list for Font Families .........................

;;;;;;;;;;; Begin Title-Text List--NO FONT FAMILIES 
  '("ttx1"          "TXT"        "TXT"        ) 
  '("ttx2"          "TXT"        "TXT"        )
  '("ttx3"          "TXT"        "TXT"        )
  '("ttx4"          "TXT"        "TXT"        )
;; End list for Non-Families 

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
)) ; end list                                              ;
) ; end v_fonts                                            ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
